/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: Fieldbus_Functions.c 12947 2019-04-10 14:18:28Z LuisContreras $:

  Description:
    General example functions for file handling

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2019-04-05  - Use Hilscher Definitions
                - Change indication handling, referencing protocol stack examples/API
    2018-08-08  review
    2018-07-26  Changed memory area initialization to OS_Memset()
    2013-01-18  Added hardware function macros
    2012-04-17  initial version

**************************************************************************************/

#include "cifXHWFunctions.h"

/* Error & Type Def. */
#include "CIFXErrors.h"
#include "CIFXEndianess.h"

#include "Hil_Results.h"
#include "Hil_ApplicationCmd.h"

/* ============================================================================= */
/* Global information and definitions                                            */
/* ============================================================================= */
/* Global data */
extern uint32_t ulSourceID;
extern uint8_t  bHandleIndications;

/*****************************************************************************/
/*! Register Application
 * \param ptChannel Channel instance pointer
 * \return CIFX_NO_ERROR on success                                          */
/*****************************************************************************/
int32_t Fieldbus_RegisterApplication( PCHANNELINSTANCE ptChannel)
{
  /* Register Application to get Indications from the stack */
  int32_t                 lRet              = CIFX_NO_ERROR;
  CIFX_PACKET             tReceivePacket;
  HIL_REGISTER_APP_REQ_T  tRegisterAppReq;

  OS_Memset( &tRegisterAppReq,  0, sizeof (HIL_REGISTER_APP_REQ_T) );
  OS_Memset( &tReceivePacket,   0, sizeof(tReceivePacket));

  /* Create a register application request */
  tRegisterAppReq.tHead.ulDest          = HOST_TO_LE32(HIL_PACKET_DEST_DEFAULT_CHANNEL);
  tRegisterAppReq.tHead.ulSrc           = HOST_TO_LE32(ulSourceID);
  tRegisterAppReq.tHead.ulLen           = HOST_TO_LE32(0);
  tRegisterAppReq.tHead.ulCmd           = HOST_TO_LE32(HIL_REGISTER_APP_REQ);

  /* send configuration Req packet */
  lRet = DEV_TransferPacket(  ptChannel, (CIFX_PACKET*)&tRegisterAppReq, &tReceivePacket,
                              sizeof(tReceivePacket), CIFX_TO_SEND_PACKET, NULL, NULL);

  /* check if we got an error */
  if (CIFX_NO_ERROR == lRet)
    lRet = tReceivePacket.tHeader.ulState;

  return lRet;
}

